/*
 * Decompiled with CFR 0.152.
 */
package org.magmacollective.darkcrystal.keybackup.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.magmacollective.darkcrystal.keybackup.crypto.KeyBackupCrypto;

public class EdDSA {
    public static final int SIGNATURE_LENGTH = 64;
    public static final int PUBLIC_KEY_LENGTH = 32;
    private static final EdDSANamedCurveSpec CURVE_SPEC = EdDSANamedCurveTable.getByName((String)"Ed25519");

    public EdDSA() {
        Security.addProvider((Provider)new EdDSASecurityProvider());
    }

    public KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EdDSA");
        return keyGen.generateKeyPair();
    }

    public byte[] PublicKeyToBytes(PublicKey publicKey) {
        EdDSAPublicKey pk = (EdDSAPublicKey)publicKey;
        return pk.getAbyte();
    }

    public PublicKey PublicKeyFromBytes(byte[] publicKeyBytes) throws Exception {
        return new EdDSAPublicKey(new EdDSAPublicKeySpec(publicKeyBytes, (EdDSAParameterSpec)CURVE_SPEC));
    }

    public byte[] signMessage(byte[] message, PrivateKey privateKey) throws Exception {
        return KeyBackupCrypto.byteArrayConcat(this.signMessageDetached(message, privateKey), message);
    }

    public Boolean verifyMessage(byte[] messageWithSignature, PublicKey publicKey) throws Exception {
        byte[] signature = new byte[64];
        byte[] message = new byte[messageWithSignature.length - 64];
        System.arraycopy(messageWithSignature, 0, signature, 0, 64);
        System.arraycopy(messageWithSignature, 64, message, 0, message.length);
        return this.verifyMessageDetached(message, publicKey, signature);
    }

    public static byte[] detachMessage(byte[] messageWithSignature) {
        byte[] message = new byte[messageWithSignature.length - 64];
        System.arraycopy(messageWithSignature, 64, message, 0, message.length);
        return message;
    }

    public byte[] signMessageDetached(byte[] message, PrivateKey privateKey) throws Exception {
        EdDSAEngine signer = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
        signer.initSign(privateKey);
        signer.update(message);
        return signer.sign();
    }

    public Boolean verifyMessageDetached(byte[] message, PublicKey publicKey, byte[] signature) throws Exception {
        EdDSAEngine verifier = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
        verifier.initVerify(publicKey);
        verifier.update(message);
        return verifier.verify(signature);
    }
}

