/*
 * Decompiled with CFR 0.152.
 */
package org.magmacollective.darkcrystal.keybackup.crypto;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.whispersystems.curve25519.Curve25519;
import org.whispersystems.curve25519.Curve25519KeyPair;

public class KeyBackupCrypto {
    public static final int SYMMETRIC_KEY_BYTES = 32;
    public static final int NONCE_BYTES = 24;
    public static final int MAC_BYTES = 16;
    public static final int BLAKE2B_BYTES = 32;
    public static final int CURVE25519_PUBLIC_KEY_BYTES = 32;
    public static final int CURVE25519_SECRET_KEY_BYTES = 32;

    public static Curve25519KeyPair generateCurve25519Keypair() {
        return Curve25519.getInstance((String)"best").generateKeyPair();
    }

    public static byte[] calculateAgreement(byte[] publicKey, byte[] privateKey) {
        Curve25519 cipher = Curve25519.getInstance((String)"best");
        return cipher.calculateAgreement(publicKey, privateKey);
    }

    public static byte[] blake2b(byte[] message) {
        Blake2bDigest digest = new Blake2bDigest(null, 32, null, null);
        digest.update(message, 0, message.length);
        byte[] hash = new byte[32];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static byte[] blake2b(byte[] message, byte[] key) {
        Blake2bDigest digest = new Blake2bDigest(key, 32, null, null);
        digest.update(message, 0, message.length);
        byte[] hash = new byte[32];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static byte[] box(byte[] message, Curve25519KeyPair keypair, byte[] recipientPublicKey) {
        byte[] dhAgreement = KeyBackupCrypto.calculateAgreement(recipientPublicKey, keypair.getPrivateKey());
        byte[] sharedSecret = KeyBackupCrypto.blake2b(KeyBackupCrypto.byteArrayConcat(keypair.getPublicKey(), recipientPublicKey), dhAgreement);
        return KeyBackupCrypto.encrypt(message, sharedSecret);
    }

    public static byte[] box(byte[] message, Curve25519KeyPair keypair, byte[] recipientPublicKey, byte[] contextData) {
        byte[] dhAgreement = KeyBackupCrypto.calculateAgreement(recipientPublicKey, keypair.getPrivateKey());
        byte[] sharedSecret = KeyBackupCrypto.blake2b(KeyBackupCrypto.byteArrayConcat(KeyBackupCrypto.byteArrayConcat(keypair.getPublicKey(), recipientPublicKey), contextData), dhAgreement);
        return KeyBackupCrypto.encrypt(message, sharedSecret);
    }

    public static byte[] unbox(byte[] ciphertext, Curve25519KeyPair keypair, byte[] senderPublicKey) throws GeneralSecurityException {
        byte[] dhAgreement = KeyBackupCrypto.calculateAgreement(senderPublicKey, keypair.getPrivateKey());
        byte[] sharedSecret = KeyBackupCrypto.blake2b(KeyBackupCrypto.byteArrayConcat(senderPublicKey, keypair.getPublicKey()), dhAgreement);
        return KeyBackupCrypto.decrypt(ciphertext, sharedSecret);
    }

    public static byte[] unbox(byte[] ciphertext, Curve25519KeyPair keypair, byte[] senderPublicKey, byte[] contextData) throws GeneralSecurityException {
        byte[] dhAgreement = KeyBackupCrypto.calculateAgreement(senderPublicKey, keypair.getPrivateKey());
        byte[] sharedSecret = KeyBackupCrypto.blake2b(KeyBackupCrypto.byteArrayConcat(KeyBackupCrypto.byteArrayConcat(senderPublicKey, keypair.getPublicKey()), contextData), dhAgreement);
        return KeyBackupCrypto.decrypt(ciphertext, sharedSecret);
    }

    public static byte[] generateSymmetricKey() {
        byte[] k = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(k);
        return k;
    }

    public static byte[] generateNonce() {
        byte[] n = new byte[24];
        SecureRandom random = new SecureRandom();
        random.nextBytes(n);
        return n;
    }

    public static byte[] encrypt(byte[] message, byte[] key) {
        byte[] nonce = KeyBackupCrypto.generateNonce();
        return KeyBackupCrypto.byteArrayConcat(nonce, KeyBackupCrypto.secretBox(message, key, nonce));
    }

    public static byte[] decrypt(byte[] ciphertextWithNonce, byte[] key) throws GeneralSecurityException {
        byte[] nonce = new byte[24];
        System.arraycopy(ciphertextWithNonce, 0, nonce, 0, 24);
        byte[] ciphertext = new byte[ciphertextWithNonce.length - 24];
        System.arraycopy(ciphertextWithNonce, 24, ciphertext, 0, ciphertext.length);
        return KeyBackupCrypto.secretUnbox(key, nonce, ciphertext);
    }

    public static byte[] secretBox(byte[] message, byte[] key, byte[] nonce) {
        XSalsa20Engine xsalsa20 = new XSalsa20Engine();
        xsalsa20.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
        byte[] sk = new byte[32];
        xsalsa20.processBytes(sk, 0, 32, sk, 0);
        byte[] out = new byte[message.length + 16];
        xsalsa20.processBytes(message, 0, message.length, out, 16);
        Poly1305 poly1305 = new Poly1305();
        poly1305.init((CipherParameters)new KeyParameter(sk));
        poly1305.update(out, 16, message.length);
        poly1305.doFinal(out, 0);
        return out;
    }

    public static byte[] secretUnbox(byte[] key, byte[] nonce, byte[] ciphertext) throws GeneralSecurityException {
        XSalsa20Engine xsalsa20 = new XSalsa20Engine();
        Poly1305 poly1305 = new Poly1305();
        xsalsa20.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
        byte[] sk = new byte[32];
        xsalsa20.processBytes(sk, 0, sk.length, sk, 0);
        poly1305.init((CipherParameters)new KeyParameter(sk));
        int len = Math.max(ciphertext.length - 16, 0);
        poly1305.update(ciphertext, 16, len);
        byte[] calculatedMAC = new byte[16];
        poly1305.doFinal(calculatedMAC, 0);
        byte[] presentedMAC = new byte[16];
        System.arraycopy(ciphertext, 0, presentedMAC, 0, Math.min(ciphertext.length, 16));
        if (!MessageDigest.isEqual(calculatedMAC, presentedMAC)) {
            throw new GeneralSecurityException("Decryption failed");
        }
        byte[] plaintext = new byte[len];
        xsalsa20.processBytes(ciphertext, 16, plaintext.length, plaintext, 0);
        return plaintext;
    }

    public static byte[] byteArrayConcat(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static byte[] oneWayBox(byte[] message, byte[] recipientPublicKey) {
        Curve25519KeyPair ephemeralKeyPair = KeyBackupCrypto.generateCurve25519Keypair();
        return KeyBackupCrypto.byteArrayConcat(ephemeralKeyPair.getPublicKey(), KeyBackupCrypto.box(message, ephemeralKeyPair, recipientPublicKey));
    }

    public static byte[] oneWayUnbox(byte[] ciphertextWithKey, Curve25519KeyPair keyPair) throws GeneralSecurityException {
        byte[] ephemeralPublicKey = new byte[32];
        byte[] ciphertext = new byte[ciphertextWithKey.length - 32];
        System.arraycopy(ciphertextWithKey, 0, ephemeralPublicKey, 0, 32);
        System.arraycopy(ciphertextWithKey, 32, ciphertext, 0, ciphertext.length);
        return KeyBackupCrypto.unbox(ciphertext, keyPair, ephemeralPublicKey);
    }

    public static String toHexString(byte[] input) {
        return Hex.toHexString((byte[])input);
    }

    public static byte[] fromHexString(String input) {
        return Hex.decode((String)input);
    }

    public static String toBase64String(byte[] input) {
        return Base64.toBase64String((byte[])input);
    }

    public static byte[] fromBase64String(String input) {
        return Base64.decode((String)input);
    }
}

