/*
 * Decompiled with CFR 0.152.
 */
package org.magmacollective.darkcrystal.keybackup.crypto;

import org.magmacollective.darkcrystal.keybackup.crypto.KeyBackupCrypto;
import org.whispersystems.curve25519.Curve25519KeyPair;

public class KeyBackupCryptoMain {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static void main(String[] args) {
        KeyBackupCrypto keyBackupCrypto = new KeyBackupCrypto();
        Curve25519KeyPair senderKeyPair = keyBackupCrypto.generateCurve25519Keypair();
        System.out.println("Generating Sender Curve25519 Keypair");
        System.out.println("Public Key: " + KeyBackupCryptoMain.bytesToHex(senderKeyPair.getPublicKey()));
        System.out.println("Secret Key: " + KeyBackupCryptoMain.bytesToHex(senderKeyPair.getPrivateKey()));
        Curve25519KeyPair recieverKeyPair = keyBackupCrypto.generateCurve25519Keypair();
        System.out.println("Generating Receiver Curve25519 Keypair");
        System.out.println("Public Key: " + KeyBackupCryptoMain.bytesToHex(recieverKeyPair.getPublicKey()));
        System.out.println("Secret Key: " + KeyBackupCryptoMain.bytesToHex(recieverKeyPair.getPrivateKey()));
        byte[] sharedSecretReciever = KeyBackupCrypto.calculateAgreement(senderKeyPair.getPublicKey(), recieverKeyPair.getPrivateKey());
        byte[] sharedSecretSender = KeyBackupCrypto.calculateAgreement(recieverKeyPair.getPublicKey(), senderKeyPair.getPrivateKey());
        System.out.println("Shared secret for sender: " + KeyBackupCryptoMain.bytesToHex(sharedSecretSender));
        System.out.println("Shared secret for reciever: " + KeyBackupCryptoMain.bytesToHex(sharedSecretReciever));
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

